/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.eui;

import ibm.nways.jdm.eui.JDMWizard;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class JDMWizardPanel
extends Panel
implements ActionListener {
    Button nextButton;
    Button prevButton;
    Button quitButton;
    Button doneButton;
    protected JDMWizard wizard;
    protected Component contents;
    protected Panel buttons;
    protected Label title;
    public static final int MIDDLE = 0;
    public static final int FIRST = 1;
    public static final int LAST = 2;
    String panelName;

    public JDMWizardPanel() {
        this(0, "Wizard Panel", null);
    }

    public JDMWizardPanel(int n) {
        this(n, "Wizard Panel", null);
    }

    public JDMWizardPanel(String string) {
        this(0, string, null);
    }

    public JDMWizardPanel(int n, String string) {
        this(n, string, null);
    }

    public JDMWizardPanel(String string, Component component) {
        this(0, string, component);
    }

    public JDMWizardPanel(int n, String string, Component component) {
        this.setLayout(new BorderLayout());
        this.contents = component;
        this.title = new Label(" " + string, 0);
        this.title.setBackground(SystemColor.textHighlight);
        this.title.setForeground(SystemColor.textHighlightText);
        this.panelName = string;
        this.add("North", this.title);
        this.buttons = new Panel();
        this.buttons.setLayout(new FlowLayout());
        if (n != 1) {
            this.prevButton = new Button("Prev");
            this.prevButton.setForeground(SystemColor.controlText);
            this.prevButton.setBackground(SystemColor.control);
            this.prevButton.addActionListener(this);
            this.buttons.add(this.prevButton);
        }
        if (n == 2) {
            this.doneButton = new Button("Finish");
            this.doneButton.setForeground(SystemColor.controlText);
            this.doneButton.setBackground(SystemColor.control);
            this.doneButton.addActionListener(this);
            this.buttons.add(this.doneButton);
        } else {
            this.nextButton = new Button("Next");
            this.nextButton.setForeground(SystemColor.controlText);
            this.nextButton.setBackground(SystemColor.control);
            this.nextButton.addActionListener(this);
            this.buttons.add(this.nextButton);
        }
        this.quitButton = new Button("Cancel");
        this.quitButton.setForeground(SystemColor.controlText);
        this.quitButton.setBackground(SystemColor.control);
        this.quitButton.addActionListener(this);
        this.buttons.add(this.quitButton);
        this.add("South", this.buttons);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.wizard != null) {
            Button button = (Button)actionEvent.getSource();
            if (button == this.nextButton) {
                if (this.proceed()) {
                    this.wizard.next();
                    return;
                }
            } else if (button == this.prevButton) {
                if (this.abort()) {
                    this.wizard.previous();
                    return;
                }
            } else {
                if (button == this.quitButton) {
                    boolean bl = false;
                    Vector vector = this.wizard.getWizardPanels();
                    int n = vector.size() - 1;
                    while (n > 0) {
                        JDMWizardPanel jDMWizardPanel = (JDMWizardPanel)vector.elementAt(n);
                        if (jDMWizardPanel == this) {
                            bl = true;
                        }
                        if (bl) {
                            jDMWizardPanel.abort();
                        }
                        --n;
                    }
                    this.wizard.cancel();
                    return;
                }
                if (button == this.doneButton && this.proceed()) {
                    this.wizard.cancel();
                }
            }
        }
    }

    public Component getContents() {
        return this.contents;
    }

    public void setContents(Component component) {
        this.contents = component;
        this.add("Center", this.contents);
        this.doLayout();
    }

    public void setWizard(JDMWizard jDMWizard) {
        this.wizard = jDMWizard;
    }

    public JDMWizard getWizard() {
        return this.wizard;
    }

    public boolean abort() {
        System.out.println("abort() called on panel " + this.panelName);
        return true;
    }

    public boolean proceed() {
        System.out.println("proceed() called on panel " + this.panelName);
        return true;
    }
}

